/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingMiner
extends AbstractBuildingStructureBuilder {
    private static final String MAIN_SHAFT_NAME = "/miner/minermainshaft";
    private static final String X4_SHAFT_NAME = "/miner/minerx4";
    private static final String X2_RIGHT_SHAFT_NAME = "/miner/minerx2right";
    private static final String X2_TOP_SHAFT_NAME = "/miner/minerx2top";
    private static final String MINER = "miner";
    private BlockPos cobbleLocation;
    private BlockPos ladderLocation;

    public BuildingMiner(IColony c, BlockPos l) {
        super(c, l);
        ItemStack stackLadder = new ItemStack((IItemProvider)Blocks.field_150468_ap);
        ItemStack stackFence = new ItemStack((IItemProvider)Blocks.field_180407_aO);
        ItemStack stackTorch = new ItemStack((IItemProvider)Blocks.field_150478_aa);
        ItemStack stackCobble = new ItemStack((IItemProvider)Blocks.field_150347_e);
        ItemStack stackDirt = new ItemStack((IItemProvider)Blocks.field_150346_d);
        this.keepX.put(arg_0 -> ((ItemStack)stackLadder).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackFence).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackTorch).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackCobble).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(stack -> stack.func_77973_b().func_206844_a((ITag)ItemTags.field_203442_w), new Tuple((Object)64, (Object)true));
        this.keepX.put(stack -> stack.func_77973_b().func_206844_a((ITag)ItemTags.field_199905_b), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackDirt).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.PICKAXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHOVEL, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return MINER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public int getResourceBatchMultiplier() {
        return 10;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.miner;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobMiner(citizen);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.ladderLocation = BlockPosUtil.readOrNull(compound, "ladderlocation");
        this.cobbleLocation = BlockPosUtil.readOrNull(compound, "cobblelocation");
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        BlockPosUtil.writeOptional(compound, "cobblelocation", this.cobbleLocation);
        BlockPosUtil.writeOptional(compound, "ladderlocation", this.ladderLocation);
        return compound;
    }

    @Override
    @NotNull
    public String getJobName() {
        return MINER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Strength;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Stamina;
    }

    public int getDepthLimit() {
        if (this.getBuildingLevel() == 1) {
            return 50;
        }
        if (this.getBuildingLevel() == 2) {
            return 30;
        }
        if (this.getBuildingLevel() >= 3) {
            return 5;
        }
        return 70;
    }

    public BlockPos getLadderLocation() {
        if (this.ladderLocation == null) {
            this.loadLadderPos();
        }
        return this.ladderLocation;
    }

    public BlockPos getCobbleLocation() {
        if (this.cobbleLocation == null) {
            this.loadLadderPos();
        }
        return this.cobbleLocation;
    }

    @Override
    public void setTileEntity(AbstractTileEntityColonyBuilding te) {
        super.setTileEntity(te);
        this.loadLadderPos();
    }

    private void loadLadderPos() {
        Map map = this.tileEntity.getWorldTagNamePosMap();
        Set cobblePos = map.getOrDefault("cobble", new HashSet());
        Set ladderPos = map.getOrDefault("ladder", new HashSet());
        if (cobblePos.isEmpty() || ladderPos.isEmpty()) {
            return;
        }
        this.cobbleLocation = (BlockPos)cobblePos.iterator().next();
        this.ladderLocation = (BlockPos)ladderPos.iterator().next();
    }

    @Override
    public void searchWorkOrder() {
        ICitizenData citizen = this.getMainCitizen();
        if (citizen == null) {
            return;
        }
        List<WorkOrderBuildMiner> list = this.getColony().getWorkManager().getOrderedList(WorkOrderBuildMiner.class, this.getPosition());
        for (WorkOrderBuildMiner wo : list) {
            if (!this.getID().equals((Object)wo.getMinerBuilding())) continue;
            citizen.getJob(JobMiner.class).setWorkOrder(wo);
            wo.setClaimedBy(citizen);
            return;
        }
    }

    public static void initStructure(Node mineNode, int rotateTimes, BlockPos structurePos, BuildingMiner buildingMiner, World world, JobMiner job) {
        String style = buildingMiner.getStyle();
        String requiredName = null;
        int rotateCount = 0;
        if (mineNode == null) {
            rotateCount = BuildingMiner.getRotationFromVector(buildingMiner);
            requiredName = BuildingMiner.getCorrectStyleLocation(style, MAIN_SHAFT_NAME, world, buildingMiner);
        } else {
            rotateCount = rotateTimes;
            if (mineNode.getStyle() == Node.NodeType.CROSSROAD) {
                requiredName = BuildingMiner.getCorrectStyleLocation(style, X4_SHAFT_NAME, world, buildingMiner);
            } else if (mineNode.getStyle() == Node.NodeType.BEND) {
                requiredName = BuildingMiner.getCorrectStyleLocation(style, X2_RIGHT_SHAFT_NAME, world, buildingMiner);
            } else if (mineNode.getStyle() == Node.NodeType.TUNNEL) {
                requiredName = BuildingMiner.getCorrectStyleLocation(style, X2_TOP_SHAFT_NAME, world, buildingMiner);
            }
        }
        if (requiredName != null && (job == null || job.getWorkOrder() == null)) {
            WorkOrderBuildMiner wo = new WorkOrderBuildMiner(requiredName, requiredName, rotateCount, structurePos, false, buildingMiner.getPosition());
            wo.setClaimedBy(buildingMiner.getPosition());
            buildingMiner.getColony().getWorkManager().addWorkOrder(wo, false);
            if (job != null) {
                job.setWorkOrder(wo);
            } else {
                wo.setClaimedBy(buildingMiner.getPosition());
            }
        }
        buildingMiner.markDirty();
    }

    private static int getRotationFromVector(BuildingMiner buildingMiner) {
        BlockPos vector = buildingMiner.getLadderLocation().func_177973_b((Vector3i)buildingMiner.getCobbleLocation());
        if (vector.func_177958_n() == 1) {
            return 1;
        }
        if (vector.func_177952_p() == 1) {
            return 2;
        }
        if (vector.func_177958_n() == -1) {
            return 3;
        }
        if (vector.func_177952_p() == -1) {
            return 4;
        }
        return 0;
    }

    private static String getCorrectStyleLocation(String style, String shaft, World world, BuildingMiner buildingMiner) {
        LoadOnlyStructureHandler wrapper = new LoadOnlyStructureHandler(world, buildingMiner.getPosition(), "schematics/" + style + shaft, new PlacementSettings(), true);
        if (wrapper.hasBluePrint()) {
            return "schematics/" + style + shaft;
        }
        return "schematics" + shaft;
    }

    public static class View
    extends AbstractBuildingBuilderView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, BuildingMiner.MINER);
        }
    }
}

